<?php $__env->startSection('title', 'Appointment Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Appointment Details</h1>
    <a href="<?php echo e(route('admin.appointments.index')); ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Back
    </a>
</div>

<div class="row g-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Patient Information</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="200">Name:</th>
                        <td><?php echo e($appointment->name); ?></td>
                    </tr>
                    <tr>
                        <th>Age:</th>
                        <td><?php echo e($appointment->age); ?> years</td>
                    </tr>
                    <tr>
                        <th>Email:</th>
                        <td><a href="mailto:<?php echo e($appointment->email); ?>"><?php echo e($appointment->email); ?></a></td>
                    </tr>
                    <tr>
                        <th>Phone:</th>
                        <td><a href="tel:<?php echo e($appointment->phone); ?>"><?php echo e($appointment->phone); ?></a></td>
                    </tr>
                    <tr>
                        <th>Preferred Time:</th>
                        <td><?php echo e($appointment->preferred_time->format('F d, Y h:i A')); ?></td>
                    </tr>
                    <tr>
                        <th>Selected Doctor:</th>
                        <td><?php echo e($appointment->doctor ? $appointment->doctor->name . ' - ' . $appointment->doctor->specialization : 'Any Doctor'); ?></td>
                    </tr>
                    <?php if($appointment->message): ?>
                    <tr>
                        <th>Message:</th>
                        <td><?php echo e($appointment->message); ?></td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Status</h5>
            </div>
            <div class="card-body">
                <p>
                    <span class="badge bg-<?php echo e($appointment->status == 'pending' ? 'warning' : ($appointment->status == 'confirmed' ? 'success' : 'danger')); ?> fs-6">
                        <?php echo e(ucfirst($appointment->status)); ?>

                    </span>
                </p>
                <p class="text-muted small mb-0">
                    <strong>Submitted:</strong><br>
                    <?php echo e($appointment->created_at->format('F d, Y h:i A')); ?>

                </p>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">Update Status</h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.appointments.updateStatus', $appointment)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <div class="mb-3">
                        <select name="status" class="form-select" required>
                            <option value="pending" <?php echo e($appointment->status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="confirmed" <?php echo e($appointment->status == 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                            <option value="cancelled" <?php echo e($appointment->status == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">Update Status</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ Websites/ENT Care/resources/views/admin/appointments/show.blade.php ENDPATH**/ ?>